/*  Project leowl_2
    xor@frognet.net
    Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

    SUBSYSTEM:    leowl_2.exe Application
	 FILE:         leowl_2e.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
	 ========
    Source file for implementation of leowl_2Edit (TLEditFile).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "leowl_2.h"
#include "leowl_2e.h"

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_2Edit, TLEditFile)
//{{leowl_2EditRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILECLOSE, CmFileClose),
	 EV_WM_SETTEXT,
//{{leowl_2EditRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{leowl_2Edit Implementation}}

IMPLEMENT_STREAMABLE1(leowl_2Edit, TLEditFile);
//////////////////////////////////////////////////////////
// leowl_2Edit
// ==========
// Construction/Destruction handling.
leowl_2Edit::leowl_2Edit (TWindow* parent,
								  int id,
								  const char* fileName,
								  TModule* module)
	 : TLEditFile(parent, id, fileName, 0, 0, 0, 0,
    ES_SMALLINDENT | ES_SMALLSPACING | ES_CANCHANGEFONT
    | ES_FOLLOWFILENAME | ES_FILELOWER | WS_HSCROLL | WS_VSCROLL
    , module)
{
    // Change a little LEdit behavour
    SetFileMask("CPP/C++ files/*.cpp/Header files/*.h/All files/*.*/");
    lpFont = new TFont((HFONT) GetStockObject(DEVICE_DEFAULT_FONT));
    SetSyntax("0");
}


leowl_2Edit::~leowl_2Edit ()
{
    Destroy();
}

void
leowl_2Edit::OnGotFocus()
{
  TLEditFile::OnGotFocus();
  leowl_2* aP = TYPESAFE_DOWNCAST(GetApplication(), leowl_2);
  SetInsertMode(aP->mdiClient->sB->GetModeIndicator(TStatusBar::Overtype));
}

void leowl_2Edit::CmFileClose ()
{
	 CloseWindow();
}

void leowl_2Edit::EvSetText (LPSTR text)
{
	 Parent->SetWindowText(text);
    DefaultProcessing();
}

//////////////////////////////////////////////////////////////////
/// Streamable implementation
///
void *
leowl_2Edit::Streamer::Read(ipstream& is, uint32) const
{
  leowl_2Edit* Obj = GetObject();
  ReadBaseObject((TLEditFile*) Obj, is);
  return Obj;
}

void
leowl_2Edit::Streamer::Write(opstream& os) const
{
  leowl_2Edit* Obj = GetObject();
  WriteBaseObject((TLEditFile*) Obj, os);
}




BOOL leowl_2Edit::Create ()
{
	 BOOL result;
	 result = TLEditFile::Create();
    if (result)
      {
        char Buf[255];
        GetCaption(Buf,255);
        Parent->SetWindowText(Buf);
      }

    return result;
}

